<?php
/**
 * GeneratePress.
 *
 * Please do not make any edits to this file. All edits should be done in a child theme.
 *
 * @package GeneratePress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Set our theme version.
define( 'GENERATE_VERSION', '3.6.0' );

if ( ! function_exists( 'generate_setup' ) ) {
	add_action( 'after_setup_theme', 'generate_setup' );
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * @since 0.1
	 */
	function generate_setup() {
		// Make theme available for translation.
		load_theme_textdomain( 'generatepress' );

		// Add theme support for various features.
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'quote', 'link', 'status' ) );
		add_theme_support( 'woocommerce' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption', 'script', 'style' ) );
		add_theme_support( 'customize-selective-refresh-widgets' );
		add_theme_support( 'align-wide' );
		add_theme_support( 'responsive-embeds' );

		$color_palette = generate_get_editor_color_palette();

		if ( ! empty( $color_palette ) ) {
			add_theme_support( 'editor-color-palette', $color_palette );
		}

		add_theme_support(
			'custom-logo',
			array(
				'height' => 70,
				'width' => 350,
				'flex-height' => true,
				'flex-width' => true,
			)
		);

		// Register primary menu.
		register_nav_menus(
			array(
				'primary' => __( 'Primary Menu', 'generatepress' ),
			)
		);

		/**
		 * Set the content width to something large
		 * We set a more accurate width in generate_smart_content_width()
		 */
		global $content_width;
		if ( ! isset( $content_width ) ) {
			$content_width = 1200; /* pixels */
		}

		// Add editor styles to the block editor.
		add_theme_support( 'editor-styles' );

		$editor_styles = apply_filters(
			'generate_editor_styles',
			array(
				'assets/css/admin/block-editor.css',
			)
		);

		add_editor_style( $editor_styles );
	}
}

/**
 * Get all necessary theme files
 */
$theme_dir = get_template_directory();

require $theme_dir . '/inc/theme-functions.php';
require $theme_dir . '/inc/defaults.php';
require $theme_dir . '/inc/class-css.php';
require $theme_dir . '/inc/css-output.php';
require $theme_dir . '/inc/general.php';
require $theme_dir . '/inc/customizer.php';
require $theme_dir . '/inc/markup.php';
require $theme_dir . '/inc/typography.php';
require $theme_dir . '/inc/plugin-compat.php';
require $theme_dir . '/inc/block-editor.php';
require $theme_dir . '/inc/class-typography.php';
require $theme_dir . '/inc/class-typography-migration.php';
require $theme_dir . '/inc/class-html-attributes.php';
require $theme_dir . '/inc/class-theme-update.php';
require $theme_dir . '/inc/class-rest.php';
require $theme_dir . '/inc/deprecated.php';

if ( is_admin() ) {
	require $theme_dir . '/inc/meta-box.php';
	require $theme_dir . '/inc/class-dashboard.php';
}

/**
 * Load our theme structure
 */
require $theme_dir . '/inc/structure/archives.php';
require $theme_dir . '/inc/structure/comments.php';
require $theme_dir . '/inc/structure/featured-images.php';
require $theme_dir . '/inc/structure/footer.php';
require $theme_dir . '/inc/structure/header.php';
require $theme_dir . '/inc/structure/navigation.php';
require $theme_dir . '/inc/structure/post-meta.php';
require $theme_dir . '/inc/structure/sidebars.php';
require $theme_dir . '/inc/structure/search-modal.php';

function so_create_meta_description() {
    // 모든 단일 글, 페이지, 그리고 카테고리 지정되지 않은 글에도 적용
    if ( is_single() || is_page() ) {
        global $post;
        $og_desc = get_post_meta( $post->ID, '_yoast_wpseo_opengraph-description', true );

        // og:description이 있다면 해당 내용을 description으로 사용
        if ( ! empty( $og_desc ) ) {
            echo '<meta name="description" content="' . esc_attr( $og_desc ) . '">' . "\n";
        }
        // excerpt도 없다면 내용의 첫 150자를 사용
        else {
            $content = wp_strip_all_tags( get_the_content() );
            $excerpt = wp_trim_words( $content, 30, '...' ); // 약 150자
            echo '<meta name="description" content="' . esc_attr( $excerpt ) . '">' . "\n";
        }
    }
}
add_action( 'wp_head', 'so_create_meta_description', 1 );

// // 글 저장 시 작성자 IP 기록
function save_author_ip($post_id) {
    // 자동 저장 시에는 실행하지 않음
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    
    // 사용자 IP 가져오기
    $user_ip = $_SERVER['REMOTE_ADDR'];
    
    // IP를 포스트 메타에 저장
    update_post_meta($post_id, '_author_ip_address', $user_ip);
}
add_action('save_post', 'save_author_ip');

// 관리자에서 IP 정보 표시
function display_author_ip($column) {
    if ($column == 'author_ip') {
        $ip = get_post_meta(get_the_ID(), '_author_ip_address', true);
        if ($ip) {
            echo $ip;
        } else {
            echo 'IP 기록 없음';
        }
    }
}
add_action('manage_posts_custom_column', 'display_author_ip');

// 관리자 목록에 IP 컬럼 추가
function add_ip_column($columns) {
    $columns['author_ip'] = '작성자 IP';
    return $columns;
}
add_filter('manage_posts_columns', 'add_ip_column');